<?php

namespace RCCFicoScore\Client;

use \Exception;

class HeaderSelector
{
    
    public function selectHeaders($accept, $contentTypes)
    {
        $headers = [];
        $accept = $this->selectAcceptHeader($accept);
        if ($accept !== null) {
            $headers['Accept'] = $accept;
        }
        $headers['Content-Type'] = $this->selectContentTypeHeader($contentTypes);
        return $headers;
    }
    
    public function selectHeadersForMultipart($accept)
    {
        $headers = $this->selectHeaders($accept, []);
        unset($headers['Content-Type']);
        return $headers;
    }
    
    private function selectAcceptHeader($accept)
    {
        if (count($accept) === 0 || (count($accept) === 1 && $accept[0] === '')) {
            return null;
        } elseif (preg_grep("/application\/json/i", $accept)) {
            return 'application/json';
        } else {
            return implode(',', $accept);
        }
    }
    
    private function selectContentTypeHeader($contentType)
    {
        if (count($contentType) === 0 || (count($contentType) === 1 && $contentType[0] === '')) {
            return 'application/json';
        } elseif (preg_grep("/application\/json/i", $contentType)) {
            return 'application/json';
        } else {
            return implode(',', $contentType);
        }
    }
}
