
<?php
require '../vendor/autoload.php';

use \GuzzleHttp\Client;
use \GuzzleHttp\HandlerStack as handlerStack;

use \RCCFicoScore\Client\Api\RCCFicoScoreApi;
use \RCCFicoScore\Client\ApiException;
use \RCCFicoScore\Client\Configuration;
use RCCFicoScore\Client\Model\CatalogoEstados;
use RCCFicoScore\Client\Model\PersonaPeticion;
use RCCFicoScore\Client\Model\DomicilioPeticion;

use Signer\Manager\Interceptor\MiddlewareEvents;
use Signer\Manager\Interceptor\KeyHandler;

use \RCCFicoScore\Client\ObjectSerializer;

function validateEmpresa($empresa = null)
{
    $autex   = 2;
    $ferreteria = 3;
    $mapco = 4;
    $sanimex = 5;
    if ($empresa == $sanimex) {
        $empresa = $sanimex;
    } elseif ($empresa == $autex) {
        $empresa = $autex;
    } elseif ($empresa == $mapco) {
        $empresa = $mapco;
    } elseif ($empresa == $ferreteria) {
        $empresa = $ferreteria;
    } else {
        throw new Exception("La empresa no existe  -> " . $empresa);
    }
    return $empresa;
}

class Consulta
{
    const HOST = 'https://services.circulodecredito.com.mx/v2/rccficoscore/';
    const BASE_PATH = __DIR__;

    const AUTEX_PAY   = 2; //  "AUTEX";
    const FERRETERIA  = 3; // "FERRETERIA";
    const MAPCO       = 4; //"MAPCO";
    const SANIMEX     = 5; //"SANIMEX";

    public $empresa = null;
    public $usuario = null;
    public $password = null;
    public $x_api_key = null;

    private $keypairPath   = "";
    private $certPath      = "";
    private $password_cert = "";
    private $options       = [];
    private $signer        = null;
    private $events        = null;
    private $handler       = null;
    private $client        = null;
    private $config        = null;
    private $apiInstance   = null;



    public function __construct($empresa = self::SANIMEX)
    {

        $this->options = [
            self::SANIMEX => [
                'username' => 'JMD1232ACR',

                'password' => 'Mapco082024$',
                'x_api_key' => 'Hxg6ihfb0SGtFuBHxh7MchEG3eyvUKAV',
                'keypairPath'   => self::BASE_PATH . '/../data/sanimex/keypair.p12',
                'certPath'      => self::BASE_PATH . '/../data/sanimex/cdc_cert.pem',
                'password_cert' => 'ls:crm*123',

            ],
            self::MAPCO => [
                'username' => 'JMD1232ACR',

                'password' => 'Mapco082024$',
                'x_api_key' => 'Hxg6ihfb0SGtFuBHxh7MchEG3eyvUKAV',
                'keypairPath'   => self::BASE_PATH . '/../data/sanimex/keypair.p12',
                'certPath'      => self::BASE_PATH . '/../data/sanimex/cdc_cert.pem',
                'password_cert' => 'ls:crm*123',

            ],
            self::AUTEX_PAY => [
                'username' => 'YGJ0706AUT',
                'password' => 'Dic2025Autex$', //Ene2025Autex$   Oct2024Autex$ Ago2025Autex$
                'x_api_key' => 'ebnQsCvobny4gbFGUK2SqKjbL00n1qz1',
                'keypairPath'   => self::BASE_PATH . '/../data/autex/keypair.p12',
                'certPath'      => self::BASE_PATH . '/../data/autex/cdc_cert.pem',
                'password_cert' => 'ls:crm*123',

            ]
        ];

        $this->empresa         = $empresa;
        $this->usuario         = $this->options[$empresa]['username'];
        $this->password        = $this->options[$empresa]['password'];
        $this->x_api_key       = $this->options[$empresa]['x_api_key'];
        $this->keypairPath     = $this->options[$empresa]['keypairPath'];
        $this->certPath        = $this->options[$empresa]['certPath'];
        $this->password_cert   = $this->options[$empresa]['password_cert'];

        $this->signer = new KeyHandler($this->keypairPath, $this->certPath, $this->password_cert);
        $this->events = new MiddlewareEvents($this->signer);
        $this->handler = handlerStack::create();
        $this->handler->push($this->events->add_signature_header('x-signature'));
        $this->handler->push($this->events->verify_signature_header('x-signature'));
        $this->client = new Client(['handler' => $this->handler]);

        $this->config = new Configuration();
        $this->config->setHost(self::HOST);

        $this->apiInstance = new RCCFicoScoreApi($this->client, $this->config);
        #$this->apiInstance = new RCCFicoScoreApi($this->client, $this->config);


    }



    private function validateData(array $data)
    {
        $requiredFields = [
            'apellidoPaterno',
            'apellidoMaterno',
            'primerNombre',
            'fechaNacimiento',
            'RFC',
            'domicilio' => ['direccion', 'coloniaPoblacion', 'delegacionMunicipio', 'ciudad', 'estado', 'CP']
        ];

        foreach ($requiredFields as $key => $fields) {
            if (is_array($fields)) {
                // Validar los campos dentro de domicilio
                if (!isset($data['domicilio']) || !is_array($data['domicilio'])) {
                    throw new InvalidArgumentException("El campo 'domicilio' es obligatorio y debe ser un array.");
                }
                foreach ($fields as $subKey) {
                    if (!isset($data['domicilio'][$subKey]) || $data['domicilio'][$subKey] === '') {
                        throw new InvalidArgumentException("El campo 'domicilio.{$subKey}' no puede ser null o vacío.");
                    }
                }
            } else {
                // Validar campos normales
                if (!isset($data[$fields]) || $data[$fields] === '') {
                    throw new InvalidArgumentException("El campo '{$fields}' no puede ser null o vacío.");
                }
            }
        }

        return $data;
    }


    public function result($data)
    {
        try {
            //$data = json_decode($data, true);
            $data = $this->validateData($data);

            $estado = new CatalogoEstados();
            $request = new PersonaPeticion();
            $domicilio = new DomicilioPeticion();

            $request->setApellidoPaterno($data['apellidoPaterno']);
            $request->setApellidoMaterno($data['apellidoMaterno']);
            $request->setApellidoAdicional(null);
            $request->setPrimerNombre($data['primerNombre']);
            $request->setSegundoNombre(null);
            $request->setFechaNacimiento($data['fechaNacimiento']);
            $request->setRfc($data['RFC']);
            $request->setCurp(null);
            $request->setNacionalidad('MX');
            $request->setResidencia(null);
            $request->setEstadoCivil(null);
            $request->setSexo(null);
            $request->setClaveElectorIfe(null);
            $request->setNumeroDependientes(null);
            $request->setFechaDefuncion(null);

            $domicilio->setDireccion($data['domicilio']['direccion']);
            $domicilio->setColoniaPoblacion($data['domicilio']['coloniaPoblacion']);
            $domicilio->setDelegacionMunicipio($data['domicilio']['delegacionMunicipio']);
            $domicilio->setCiudad($data['domicilio']['ciudad']);;
            $domicilio->setEstado($data['domicilio']['estado']);
            $domicilio->setCp($data['domicilio']['CP']."");
            $domicilio->setFechaResidencia(null);
            $domicilio->setNumeroTelefono(null);
            $domicilio->setTipoDomicilio(null);
            $domicilio->setTipoAsentamiento(null);
            $request->setDomicilio($domicilio);
            $result =  $this->apiInstance->getReporte($this->x_api_key, $this->usuario, $this->password, $request);
            $this->signer->close();
            //print_r($result);
            //$this->assertTrue($result->getFolioConsulta() !== null);
            //Utiliza ObjectSerializer para convertir el objeto a un formato serializable
            $sanitizedResult = ObjectSerializer::sanitizeForSerialization($result);
            $response = json_encode([
                'code' => 202,
                'folioConsulta' => $result->getFolioConsulta(),
                'data' => $sanitizedResult,
                'message' => 'Consulta exitosa'
            ]);
        } catch (\Throwable $th) {
            $response = json_encode([
                'code' => 400,
                'folioConsulta' => null,
                'data' => null,
                'message' => $th->getMessage()
            ]);
        }

        return $response;
    }
}



header("Content-Type: application/json");  // Establece el tipo de contenido a JSON

// Solo permitir solicitudes POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);  // Método no permitido
    echo json_encode(['code' => 10, 'message' => 'Método no permitido. Solo se permite POST.']);
    exit;
}

// Leer y decodificar los datos de la solicitud POST
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    http_response_code(400);  // Solicitud incorrecta
    echo json_encode(['code' => 10,   'message' => 'Datos de entrada no válidos']);
    exit;
}
//print_r($input);
//die;
try {
    //$input = json_decode($input, true);
    $empresa = $input['empresa'] ?? null;

    validateEmpresa($empresa);
    $api = new Consulta($empresa);
    $result = $api->result($input);
    echo $result;

    exit;
} catch (Exception $e) {
    echo json_encode(['code' => 10,   'message' => $e->getMessage(), 'data' => null]);
    exit;
}


echo json_encode(['code' => 10,   'message' => 'ALGO SALIO MAL', 'data' => null]);
exit;
